/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals;

import emulator.hardware.io.peripherals.VicTapeContents;
import emulator.hardware.io.peripherals.VicTapeTrack;

public class VicTapeState {
    private VicTapeContents contents = new VicTapeContents();
    private StateBase state = new IdleState();

    public VicTapeTrack getCurrentTrack() {
        return this.contents.getCurrentTrack();
    }

    public void addTrack(VicTapeTrack track) {
        this.contents.addTrack(track);
    }

    public VicTapeContents getContents() {
        return this.contents;
    }

    public synchronized void handlePlayEvent() {
        this.state = this.state.handlePlayEvent();
    }

    public synchronized void handleRecordEvent() {
        this.state = this.state.handleRecordEvent();
    }

    public synchronized void handleStopEvent() {
        this.state = this.state.handleStopEvent();
    }

    public synchronized boolean performPreReadEvent(boolean signal) {
        return this.state.performPreReadEvent(signal);
    }

    public synchronized boolean performPostReadEvent(boolean signal) {
        return this.state.performPostReadEvent(signal);
    }

    public synchronized boolean performPreWriteEvent(boolean signal) {
        return this.state.performPreWriteEvent(signal);
    }

    public synchronized boolean performPostWriteEvent(boolean signal) {
        return this.state.performPostWriteEvent(signal);
    }

    class IdleState
    extends StateBase {
        IdleState() {
        }

        @Override
        public StateBase handlePlayEvent() {
            return new PlayState(VicTapeState.this.getCurrentTrack());
        }

        @Override
        public StateBase handleRecordEvent() {
            return new RecordState();
        }
    }

    class PlayState
    extends StateBase {
        VicTapeTrack track;
        long counter;

        public PlayState(VicTapeTrack track) {
            this.track = null;
            this.counter = 0L;
            this.track = track;
        }

        @Override
        public StateBase handleStopEvent() {
            return new IdleState();
        }

        @Override
        public boolean performPreReadEvent(boolean signal) {
            ++this.counter;
            return this.track.playSignal(this.counter);
        }

        @Override
        public boolean performPostReadEvent(boolean signal) {
            return signal;
        }
    }

    class RecordState
    extends StateBase {
        VicTapeTrack track;
        boolean last_value;
        long counter;

        RecordState() {
            this.track = new VicTapeTrack();
            this.last_value = false;
            this.counter = 0L;
        }

        @Override
        public StateBase handleStopEvent() {
            VicTapeState.this.addTrack(this.track);
            return new IdleState();
        }

        @Override
        public boolean performPreWriteEvent(boolean signal) {
            ++this.counter;
            return signal;
        }

        @Override
        public boolean performPostWriteEvent(boolean signal) {
            if (signal != this.last_value) {
                this.track.recordSignal(this.counter, signal);
                this.last_value = signal;
            }
            return signal;
        }
    }

    abstract class StateBase {
        StateBase() {
        }

        StateBase handleRecordEvent() {
            return this;
        }

        StateBase handlePlayEvent() {
            return this;
        }

        StateBase handleStopEvent() {
            return this;
        }

        boolean performPreReadEvent(boolean signal) {
            return signal;
        }

        boolean performPostReadEvent(boolean signal) {
            return signal;
        }

        boolean performPreWriteEvent(boolean signal) {
            return signal;
        }

        boolean performPostWriteEvent(boolean signal) {
            return signal;
        }
    }
}

